# Smart SEO Audit License Server – Installation Instructions

## Requirements

- PHP 7.4+ (recommended 8.0+)
- MySQL 5.7+ or MariaDB 10.3+
- HTTPS (required for production)
- cURL enabled in PHP

---

## 1. Upload Files

Upload the entire `license-api` folder to your server (e.g. `https://yourdomain.com/license-api/`).

Recommended: place it outside the public web root and expose only the API scripts via your web server config, or keep inside web root and use `.htaccess` to protect `config.php`.

---

## 2. Create Database

1. Create a MySQL database (e.g. `smart_seo_license`).
2. Import the schema:

```bash
mysql -u your_user -p smart_seo_license < database.sql
```

Or run the contents of `database.sql` in phpMyAdmin / your DB tool.

---

## 3. Configure config.php

Edit `license-api/config.php` and set:

| Key | Description |
|-----|-------------|
| `db.host` | MySQL host (usually `localhost`) |
| `db.name` | Database name |
| `db.user` | Database user |
| `db.password` | Database password |
| `envato.personal_token` | Your Envato API Personal Token |
| `envato.item_id` | Your Envato item ID (plugin/product) |
| `api_secret_key` | Strong random string (32+ chars). **The WordPress plugin must send this key with every request.** |
| `rate_limit` | Max requests per IP per hour per endpoint (default 60) |

### Envato token and item ID

- **Personal token:** [Envato Account → API](https://build.envato.com/create-token/) – create a token with “Download” and “Verify purchase information” permissions.
- **Item ID:** Your product’s numeric ID (e.g. from the product URL).

### API secret key

Generate a strong key and use the same value in your WordPress plugin:

```php
// Example: store in plugin options
define('SSA_LICENSE_API_KEY', 'your_32_char_secret_key_here');
```

---

## 4. Change default admin password

Default admin login:

- **URL:** `https://yourdomain.com/license-api/admin/`
- **Username:** `admin`
- **Password:** `change_me_immediately`

**Change the password immediately:**

1. Log in to the admin dashboard.
2. Use phpMyAdmin or MySQL to update the password:

```sql
UPDATE admin_users
SET password_hash = '$2y$10$...'
WHERE username = 'admin';
```

Generate the hash in PHP:

```php
echo password_hash('your_new_strong_password', PASSWORD_DEFAULT);
```

Replace `$2y$10$...` in the SQL with the generated hash.

---

## 5. Security checklist

- [ ] Use **HTTPS** only.
- [ ] Set correct file permissions (e.g. 644 for PHP, 600 for `config.php` if possible).
- [ ] Restrict access to `config.php` (e.g. via `.htaccess` or web server config).
- [ ] Use a strong `api_secret_key` and keep it secret.
- [ ] Change default admin password.
- [ ] Optionally restrict admin by IP in `.htaccess` or server config.

---

## 6. API Endpoints (for the WordPress plugin)

Base URL: `https://yourdomain.com/license-api/`

All endpoints require **POST** and the API key via one of:

- Header: `X-Api-Key: YOUR_API_SECRET_KEY`
- POST body: `api_key=YOUR_API_SECRET_KEY`

### 6.1 Verify (activate license)

- **File:** `verify.php`
- **POST:** `purchase_code`, `domain`, `email`
- **Response:** `{"status":"valid"}` or error with `"status":"invalid"`

### 6.2 Check (periodic validation, e.g. every 24h)

- **File:** `check.php`
- **POST:** `domain`
- **Response:** `{"status":"valid"}` or error with `"status":"invalid"`

### 6.3 Deactivate

- **File:** `deactivate.php`
- **POST:** `domain`
- **Response:** `{"status":"deactivated"}`

### 6.4 Update (plugin updates)

- **File:** `update.php`
- **POST:** `domain`, optional `current_version`
- **Response:** `status`, `update_available`, `version`, `package` (if update available)

---

## 7. Plugin integration summary

- On activation / license save: call **verify.php** with purchase code, domain, email. If `status === 'valid'`, mark plugin as licensed.
- Every 24 hours: call **check.php** with domain. If not valid, lock the plugin.
- On deactivation or “Deactivate license”: call **deactivate.php** with domain.
- For updates: call **update.php** with domain and current version; if `update_available` and `package` URL present, offer update.

The server is the **final authority**: if it returns invalid or the request fails, the plugin must lock.

---

## 8. File structure

```
license-api/
├── config.php           # Edit: DB, Envato, API key
├── database.sql         # Import into MySQL
├── .htaccess            # Optional: protect config
├── verify.php           # Activate license
├── check.php            # Check license
├── deactivate.php       # Deactivate license
├── update.php           # Update info (licensed only)
├── includes/
│   └── bootstrap.php    # DB + helpers
└── admin/
    ├── index.php        # Dashboard
    ├── login.php        # Login
    ├── logout.php       # Logout
    └── includes/
        └── bootstrap.php
```

---

## 9. Troubleshooting

- **“Invalid API key”:** Ensure the plugin sends the same `api_secret_key` as in `config.php` (header or POST).
- **“Could not verify purchase with Envato”:** Check Envato token, item ID, and purchase code. Ensure cURL can reach `https://api.envato.com`.
- **“License already activated on another domain”:** One purchase code = one domain. Use deactivate on the old site first, or revoke from admin.
- **Rate limit:** Adjust `rate_limit` in `config.php` or clean `rate_limit_log` table.

For revoking licenses or blocking domains, use the **Admin dashboard** at `/license-api/admin/`.
