# Smart SEO Audit License Server

Production-ready license server for validating Envato purchase codes and controlling WordPress plugin activation. PHP + MySQL, no framework.

## Quick start

1. Import `database.sql` into MySQL.
2. Copy `config.php` and set DB credentials, Envato token, item ID, and `api_secret_key`.
3. Point your WordPress plugin to the API base URL and use the same `api_secret_key`.
4. Log in to **Admin:** `/license-api/admin/` — default: `admin` / `change_me_immediately` (change immediately).

Full steps: see **[INSTALL.md](INSTALL.md)**.

## API endpoints

| Endpoint        | Purpose                    | Main POST params        |
|----------------|----------------------------|-------------------------|
| `verify.php`   | Activate license           | `purchase_code`, `domain`, `email` |
| `check.php`    | Validate license (e.g. 24h)| `domain`                |
| `deactivate.php` | Deactivate for domain    | `domain`                |
| `update.php`   | Plugin update info         | `domain`, optional `current_version` |

All require **POST** and API key (`X-Api-Key` header or `api_key` POST).

## Security

- Purchase codes stored as SHA-256 hash.
- One activation per purchase code (one domain).
- API key required on all requests.
- Rate limiting per IP per endpoint.
- Blocked domains table; admin can revoke or block.
- JSON-only responses; no direct browser use of API.

## Admin dashboard

- Login, view active licenses, total activations.
- Search by domain, email, or hash.
- Revoke license, block domain.

Your plugin should treat this server as the **final authority**: if the server says invalid or the request fails, the plugin must lock.
