<?php
/**
 * Admin login
 */
require __DIR__ . '/includes/bootstrap.php';

if (admin_logged_in()) {
    header('Location: index.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = trim((string) ($_POST['username'] ?? ''));
    $pass = (string) ($_POST['password'] ?? '');
    if ($user === '' || $pass === '') {
        $error = 'Username and password required.';
    } else {
        $stmt = $pdo->prepare('SELECT id, password_hash FROM admin_users WHERE username = ? LIMIT 1');
        $stmt->execute([$user]);
        $row = $stmt->fetch();
        if ($row && password_verify($pass, $row['password_hash'])) {
            $_SESSION['admin_user_id'] = (int) $row['id'];
            $_SESSION['admin_username'] = $user;
            header('Location: index.php');
            exit;
        }
        $error = 'Invalid username or password.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Admin - Login</title>
    <style>
        * { box-sizing: border-box; }
        body { font-family: system-ui, sans-serif; background: #1a1d24; color: #e2e4e8; min-height: 100vh; margin: 0; display: flex; align-items: center; justify-content: center; }
        .box { background: #252830; padding: 2rem; border-radius: 8px; width: 100%; max-width: 340px; box-shadow: 0 4px 20px rgba(0,0,0,.3); }
        h1 { margin: 0 0 1.5rem; font-size: 1.25rem; }
        label { display: block; margin-bottom: 0.35rem; font-size: 0.9rem; }
        input[type="text"], input[type="password"] { width: 100%; padding: 0.6rem; margin-bottom: 1rem; border: 1px solid #3d424d; border-radius: 4px; background: #1a1d24; color: #e2e4e8; }
        button { width: 100%; padding: 0.65rem; background: #0d6efd; color: #fff; border: none; border-radius: 4px; font-size: 1rem; cursor: pointer; }
        button:hover { background: #0b5ed7; }
        .error { color: #f87171; font-size: 0.9rem; margin-bottom: 1rem; }
    </style>
</head>
<body>
    <div class="box">
        <h1>Smart SEO Audit – License Admin</h1>
        <?php if ($error): ?><p class="error"><?php echo htmlspecialchars($error); ?></p><?php endif; ?>
        <form method="post" action="login.php">
            <label for="username">Username</label>
            <input type="text" id="username" name="username" required autocomplete="username">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" required autocomplete="current-password">
            <button type="submit">Log in</button>
        </form>
    </div>
</body>
</html>
