<?php
/**
 * Check endpoint: validate active license (plugin calls every 24h)
 * POST: domain (+ api_key or X-Api-Key header)
 */

declare(strict_types=1);

define('LICENSE_SERVER', true);

require __DIR__ . '/includes/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed', 'status' => 'invalid'], 405);
}

if (!validate_api_key($config)) {
    json_response(['error' => 'Invalid API key', 'status' => 'invalid'], 403);
}

check_rate_limit($pdo, $config, 'check');

$domain = isset($_POST['domain']) ? trim((string) $_POST['domain']) : '';
$domain = preg_replace('/^https?:\/\//i', '', $domain);
$domain = strtolower(explode('/', $domain)[0]);

if (!preg_match('/^[a-z0-9]([a-z0-9\-\.]*[a-z0-9])?$/i', $domain) || strlen($domain) > 255) {
    json_response(['error' => 'Invalid domain', 'status' => 'invalid'], 400);
}

if (is_domain_blocked($pdo, $domain)) {
    json_response(['error' => 'Domain is blocked', 'status' => 'invalid'], 403);
}

$stmt = $pdo->prepare('SELECT id, status FROM licenses WHERE domain = ? LIMIT 1');
$stmt->execute([$domain]);
$row = $stmt->fetch();

if (!$row || $row['status'] !== 'active') {
    json_response(['error' => 'License not found or inactive', 'status' => 'invalid'], 404);
}

$ip = get_client_ip();
$pdo->prepare('UPDATE licenses SET last_check = NOW(), ip_address = ? WHERE id = ?')->execute([$ip, $row['id']]);

json_response(['status' => 'valid']);
