<?php
/**
 * Update endpoint: return plugin update info only if license is active
 * POST: domain (+ api_key or X-Api-Key header)
 * Optional: current_version to return update payload only when newer version exists
 */

declare(strict_types=1);

define('LICENSE_SERVER', true);

require __DIR__ . '/includes/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed', 'status' => 'invalid'], 405);
}

if (!validate_api_key($config)) {
    json_response(['error' => 'Invalid API key', 'status' => 'invalid'], 403);
}

check_rate_limit($pdo, $config, 'update');

$domain = isset($_POST['domain']) ? trim((string) $_POST['domain']) : '';
$domain = preg_replace('/^https?:\/\//i', '', $domain);
$domain = strtolower(explode('/', $domain)[0]);

if (!preg_match('/^[a-z0-9]([a-z0-9\-\.]*[a-z0-9])?$/i', $domain) || strlen($domain) > 255) {
    json_response(['error' => 'Invalid domain', 'status' => 'invalid'], 400);
}

if (is_domain_blocked($pdo, $domain)) {
    json_response(['error' => 'Domain is blocked', 'status' => 'invalid', 'update_available' => false], 403);
}

$stmt = $pdo->prepare('SELECT id, status FROM licenses WHERE domain = ? LIMIT 1');
$stmt->execute([$domain]);
$row = $stmt->fetch();

if (!$row || $row['status'] !== 'active') {
    json_response([
        'error'            => 'License not active',
        'status'           => 'invalid',
        'update_available' => false,
    ], 403);
}

// Define current plugin version on server (bump when you release an update)
$latest_version = '1.0.0';
$package_url    = 'https://your-domain.com/releases/smart-seo-audit-1.0.0.zip'; // Secure URL, e.g. behind auth or token

$current_version = isset($_POST['current_version']) ? trim((string) $_POST['current_version']) : '0';

$update_available = version_compare($latest_version, $current_version, '>');

json_response([
    'status'           => 'valid',
    'update_available' => $update_available,
    'version'          => $latest_version,
    'package'          => $update_available ? $package_url : null,
    'requires'         => '5.6',
    'tested'           => '6.4',
]);
